<?php
	global $lumise;

	$section = 'add_price_discount';
	$fields = $lumise_admin->process_data(array(
		array(
			'type' => 'input',
			'name' => 'name',
			'label' => $lumise->lang('Name'),
			'required' => true,
			'default' => 'Untitled'
		),
		array(
			'type' => 'dropbox',
			'name' => 'discount_type',
			'label' => $lumise->lang('Discount type'),
			'options' => array(
				'discount price follow quantity' => 'price_quantity'
			)
		),
		array(
			'type' => 'input',
			'name' => 'product_list',
			'label' => $lumise->lang('Product list'),
			'desc' => $lumise->lang('Product list'),
		),
		array(
			'type' => 'input',
			'name' => 'cate_product',
			'label' => $lumise->lang('Categories'),
			'desc' => $lumise->lang('Categories of product'),
		),
		array(
			'type' => 'input',
			'name' => 'tags_product',
			'label' => $lumise->lang('Tags'),
			'desc' => $lumise->lang('Tags of product'),
		),
		array(
			'type' => 'toggle',
			'name' => 'active',
			'label' => $lumise->lang('Active'),
			'default' => 'yes',
			'value' => null
		),
		array(
			'type' => 'toggle',
			'name' => 'show_table',
			'label' => $lumise->lang('Show table'),
			'default' => 'yes',
			'value' => null
		),
		array(
			'type' => 'input',
			'name' => 'discount_rule',
			'label' => $lumise->lang('Discount config'),
			'desc' => $lumise->lang('- 1 Percentage: Percentage discount based on regular price<br/>- 2 Fixed price: Fixed discount based on regular price<br/>- 3 Fixed minus: The price will be accrued with the regular price<br><b style="color:black;">NOTE : When use the price_disocunt addon, with the quantity attribute multiple you can\'t set a price for the quantity.</b><br><br>'),
		),
	), 'price_discount');

	$product_ids = get_posts( array(
        'post_type' => 'product',
        'numberposts' => -1,
        'post_status' => 'publish'
   	));

   	$terms_cate = get_terms('product_cat');

   	$terms_tag = get_terms('product_tag');

	function get_url($file = '') {
		global $lumise;

		$key = array_search(__FUNCTION__, array_column(debug_backtrace(), 'function'));
		$path = debug_backtrace()[$key]['file'];
		$url = $lumise->cfg->upload_url.'addons/'.basename(dirname($path));
		
		if (!empty($file)){
			$url .= '/'.$file;
		}
		
		return $url;
	}
?>
<style type="text/css">
	.lumise_form_group .lumise_form_content{
	    max-width: 640px !important;
	}
	.lumise_config{
		width: 100%;
	}
	.lumise_config input, .lumise_config select{
		width: 20.1% !important;
		float: left;
	}
	.lumise_config_btn{
		float: right;
		width: 16% !important;
		text-align: right;
	}
	.btn_lumise_config {
	    cursor: pointer;
	    margin: 0px 8px;
	    font-size: 24px;
	    line-height: 23px;
	}
	.btn_plus{
		color: green;
	}
	.btn_minus{
		color: red;
	}

	.lumise_form_content .lumise_config:nth-child(1) .btn_minus{
		display: none;
	}
	input[name="discount_rule"], input[name="tags_product"], input[name="cate_product"], input[name="product_list"]{
		display: none;
	}
</style>
<div class="lumise_wrapper" id="lumise-<?php echo $section; ?>-page">
	<div class="lumise_content">
		<div class="lumise_header">
			<h2>
				<a href="<?php echo $lumise->cfg->admin_url;?>lumise-page=price_discount">Price Discount</a> 
				<i class="fa fa-angle-right"></i> Add New Price discount
			</h2>
		</div>

		<?php $lumise->views->header_message(); ?>

		<form action="<?php echo $lumise->cfg->admin_url; ?>lumise-page=<?php
			echo $section.(isset($_GET['callback']) ? '&callback='.$_GET['callback'] : '');
		?>" id="lumise-price_discount-form" method="post" class="lumise_form" enctype="multipart/form-data">

			<?php $lumise->views->tabs_render($fields); ?>

			<div class="lumise_form_group lumise_form_submit">
				<input type="submit" value="<?php echo $lumise->lang('Save Price Discount'); ?>"/>
				<input type="hidden" name="do" value="action" />
				<a class="lumise_cancel" href="<?php echo $lumise->cfg->admin_url;?>lumise-page=price_discount">
					<?php echo $lumise->lang('Cancel'); ?>
				</a>
				<input type="hidden" name="lumise-section" value="<?php echo $section; ?>">
			</div>
		</form>
	</div>
</div>
<link media="all" rel="stylesheet" href="<?php echo get_url('assets/css/select2.min.css?ver=1'); ?>" />
<script type="text/javascript" src="<?php echo get_url('assets/js/select2.min.js?ver=1'); ?>"></script>
<script type="text/javascript" src="<?php echo get_url('assets/js/price_discount_backend.js?ver=1'); ?>"></script>
<script type="text/javascript">
(function($) {
	create_product_list_select2();
	create_product_cate_select2();
	create_product_tags_select2();

	function create_product_list_select2(){
		$('input[name="product_list"]').parent().prepend('<select name="sl_product_id"></select>');

		var product_data = [
			<?php if(!empty($product_ids)){ ?>
				<?php foreach ($product_ids as $index => $detailPost) { ?>
				{
					id: <?php echo $detailPost->ID; ?>,
					text: '<?php echo addslashes($detailPost->post_title); ?>'
				},
				<?php } ?>
			<?php } ?>
		];

		$('select[name="sl_product_id"]').select2({
			placeholder: 'Select product use discount price',
			multiple: true,
			data: product_data
		});

		// exist value
		var exist_Product_arr = [];
		var exist_Product_list = $('input[name="product_list"]').val();
		if(exist_Product_list != ''){
			exist_Product_arr = exist_Product_list.split(',');
		}

		$('select[name="sl_product_id"]').val(exist_Product_arr);
		$('select[name="sl_product_id"]').trigger('change');

		// when change value
		$('select[name="sl_product_id"]').on('change', function (e) {
			var data = $(this).val();
			if(data == null){
				data = '';
			}
			$('input[name="product_list"]').val(data.toString());
		});
	}

	function create_product_cate_select2(){
		$('input[name="cate_product"]').parent().prepend('<select name="sl_product_cate"></select>');

		var product_cate = [
			<?php if(!empty($terms_cate)){ ?>
				<?php foreach ($terms_cate as $index => $detailPost) { ?>
				{
					id: <?php echo $detailPost->term_id; ?>,
					text: '<?php echo addslashes($detailPost->name); ?>'
				},
				<?php } ?>
			<?php } ?>
		];

		$('select[name="sl_product_cate"]').select2({
			placeholder: 'Select product use discount price',
			multiple: true,
			data: product_cate
		});

		// exist value
		var exist_Product_arr = [];
		var exist_Product_list = $('input[name="cate_product"]').val();
		if(exist_Product_list != ''){
			exist_Product_arr = exist_Product_list.split(',');
		}

		$('select[name="sl_product_cate"]').val(exist_Product_arr);
		$('select[name="sl_product_cate"]').trigger('change');

		// when change value
		$('select[name="sl_product_cate"]').on('change', function (e) {
			var data = $(this).val();
			if(data == null){
				data = '';
			}
			$('input[name="cate_product"]').val(data.toString());
		});
	}

	function create_product_tags_select2(){
		$('input[name="tags_product"]').parent().prepend('<select name="sl_product_tags"></select>');

		var product_tag = [
			<?php if(!empty($terms_tag)){ ?>
				<?php foreach ($terms_tag as $index => $detailPost) { ?>
				{
					id: <?php echo $detailPost->term_id; ?>,
					text: '<?php echo addslashes($detailPost->name); ?>'
				},
				<?php } ?>
			<?php } ?>
		];

		$('select[name="sl_product_tags"]').select2({
			placeholder: 'Select product use discount price',
			multiple: true,
			data: product_tag
		});

		// exist value
		var exist_Product_arr = [];
		var exist_Product_list = $('input[name="tags_product"]').val();
		if(exist_Product_list != ''){
			exist_Product_arr = exist_Product_list.split(',');
		}

		$('select[name="sl_product_tags"]').val(exist_Product_arr);
		$('select[name="sl_product_tags"]').trigger('change');

		// when change value
		$('select[name="sl_product_tags"]').on('change', function (e) {
			var data = $(this).val();
			if(data == null){
				data = '';
			}
			$('input[name="tags_product"]').val(data.toString());
		});
	}

	// discount config
	var discountConfigValue = $('input[name="discount_rule"]').val();
	if(discountConfigValue != '' && discountConfigValue != '[]'){
		let dataJson = JSON.parse(discountConfigValue);

		$.each(dataJson, function(index, detail){
			$('input[name="discount_rule"]').parent().append(renderDiscountConfig(detail.min_quantity, detail.max_quantity, detail.discount_type, detail.discount_value));
		});
	} else {
		$('input[name="discount_rule"]').parent().prepend(renderDiscountConfig());
	}

	function renderDiscountConfig(min = 0, max = 0, type = 'percentage', discount_value = 0){
		let htmlrender = '';

		htmlrender += '<div class="lumise_config">';
			htmlrender += '<input type="text" placeholder="Minimum Quantity" name="min_quantity" ';
			if(min != 0){
				htmlrender += 'value="'+min+'';
			}
			htmlrender += '" >';
			htmlrender += '<input type="text" placeholder="Maximum Quantity" name="max_quantity" ';
			if(max != 0){
				htmlrender += 'value="'+max+'';
			}
			htmlrender += '" >';
			htmlrender += '<select name="discount_type">';
				htmlrender += '<option ';
				if(type == 'percentage'){
					htmlrender += 'selected';
				}
				htmlrender += ' value="percentage">Percentage</option>';
				htmlrender += '<option ';
				if(type == 'fixed'){
					htmlrender += 'selected';
				}
				htmlrender += ' value="fixed">Fixed price</option>';
				htmlrender += '<option ';
				if(type == 'minus_fixed'){
					htmlrender += 'selected';
				}
				htmlrender += ' value="minus_fixed">Fixed minus</option>';
			htmlrender += '</select>';
			htmlrender += '<input type="text" placeholder="Discount value" name="discount_value" ';
			if(discount_value != 0){
				htmlrender += 'value="'+discount_value+'';
			}
			htmlrender += '" >';
			htmlrender += '<div class="lumise_config_btn"><span class="btn_lumise_config btn_plus" ><i class="fa fa-plus-circle" aria-hidden="true"></i></span> <span class="btn_lumise_config btn_minus"><i class="fa fa-minus-circle" aria-hidden="true"></i></span></div>';
		htmlrender += '</div>';


		// return '<div class="lumise_config"><input type="text" placeholder="Minimum Quantity" name="min_quantity" value="'+min+'" > <input type="text" placeholder="Maximum Quantity" name="max_quantity" value="'+max+'" > <select name="discount_type"><option value="percentage">Percentage</option><option value="fixed">Fixed price</option></select> <input type="text" placeholder="Discount value" name="discount_value" value="'+discount_value+'">  <div class="lumise_config_btn"><span class="btn_lumise_config btn_plus" ><i class="fa fa-plus-circle" aria-hidden="true"></i></span> <span class="btn_lumise_config btn_minus"><i class="fa fa-minus-circle" aria-hidden="true"></i></span></div></div>';

		return htmlrender;
	}

	$(document).on('click', '.btn_minus', function(){
		$(this).parents('.lumise_config').remove();
	});

	$(document).on('click', '.btn_plus', function(){
		$('input[name="discount_rule"]').parent().append(renderDiscountConfig());
	});

	$('#lumise-price_discount-form').submit(function() {
		change_discount_config();
	});

	function change_discount_config(){
		var changeValue = [];
		$('input[name="discount_rule"]').parent().find('.lumise_config').each(function(){

			var min_quantity = $(this).find('input[name="min_quantity"]').val();
			if(min_quantity == ''){
				min_quantity = 0;
			}
			min_quantity = parseFloat(min_quantity);

			var max_quantity = $(this).find('input[name="max_quantity"]').val();
			if(max_quantity == ''){
				max_quantity = 0;
			}
			max_quantity = parseFloat(max_quantity);

			var discount_type = $(this).find('select[name="discount_type"]').val();
			if(discount_type == ''){
				discount_type = 'percentage';
			}

			var discount_value = $(this).find('input[name="discount_value"]').val();
			if(discount_value == ''){
				discount_value = 0;
			}
			discount_value = parseFloat(discount_value);

			var tempObj = {
				min_quantity: min_quantity,
				max_quantity: max_quantity,
				discount_type: discount_type,
				discount_value: discount_value,
			};
			changeValue.push(tempObj);
		});

		$('input[name="discount_rule"]').val(JSON.stringify(changeValue));
	}

})(jQuery);
</script>