function lumise_addon_price_discount(lumise) {

	window.lm = lumise;
	var price_base = 0;

	// woo variation same price
	if (lumise_price_discount.is_variable == 1 && lumise_price_discount.price != 0) {
		lumise.data.onload.price = lumise_price_discount.price;
		lumise.cart.price.base = lumise_price_discount.price;
	}

	// woo variation range price
	if (lumise_price_discount.is_variable == 1 && lumise.data.onload.price != 0 ) {
		lumise.cart.price.base = lumise.data.onload.price;
		lumise_price_discount.price = lumise.data.onload.price;
		price_base = lumise.data.onload.price;
		calcPriceDiscount(true);
	}

	// woo simple product
	if (lumise_price_discount.is_variable == 0 && lumise_price_discount.price != 0) {
		// lumise simple product
		if(lumise.data.onload.variations == '' || lumise.data.onload.variations == null){
			calcPriceDiscount(true);
		}

		// lumise variation product
		if(lumise.data.onload.variations != '' && lumise.data.onload.variations != null){
			calcPriceDiscount(true);
			// base_quantity = $('.lumise-cart-field-value input.lumise-cart-param').val();
		}
	}

	lumise.add_action('cart-calc', function(){
		var quantity = 0;
		if($('.lumise-cart-field-quantity input.lumise-cart-param').attr('data-format') == 'json'){
			let jsonTotalQuantiry = JSON.parse($('.lumise-cart-field-quantity input.lumise-cart-param').val());
			$.each(jsonTotalQuantiry, function(index, qty){
				quantity += parseInt(qty);
			});
		} else {
			quantity = parseInt($('.lumise-cart-field-quantity input.lumise-cart-param').val());
		}
		lumise_price_discount.quantity = quantity;
		calcPriceDiscount(true);
	});

	lumise.add_action('cart-changed', function(){
		// woo simple & varation lumise
		if(lumise_price_discount.is_variable == 0 && lumise_price_discount.price != 0 && lumise.data.variations != '' && lumise.data.variations != null && sessionStorage.getItem("LUMISE-CHANGE-QUANTITY") === null){
			// lumise_price_discount.price = lumise.cart.price.base;
		}

		var quantity = 0;
		if($('.lumise-cart-field-quantity input.lumise-cart-param').attr('data-format') == 'json'){
			let jsonTotalQuantiry = JSON.parse($('.lumise-cart-field-quantity input.lumise-cart-param').val());
			$.each(jsonTotalQuantiry, function(index, qty){
				quantity += parseInt(qty);
			});
		} else {
			quantity = parseInt($('.lumise-cart-field-quantity input.lumise-cart-param').val());
		}

		lumise_price_discount.quantity = quantity;
		calcPriceDiscount(true);
		sessionStorage.removeItem('LUMISE-CHANGE-QUANTITY');
	});

	lumise.add_action('vari_data_price', function(vari_data){
		// woo simple & varation lumise
		if(lumise_price_discount.is_variable == 0 && lumise_price_discount.price != 0 && lumise.data.variations != '' && lumise.data.variations != null){
			lumise_price_discount.price = vari_data.price;
			price_base = vari_data.price;
		}

		// woo product variation
		if (lumise_price_discount.is_variable == 1 && lumise_price_discount.price != 0) {
			lumise_price_discount.price = vari_data.price;
			price_base = vari_data.price;
			// lumise.data.onload.price = vari_data.price;
			lumise.cart.price.base = vari_data.price;
		}
		lumise_price_discount.quantity = $('.lumise-cart-field-value input.lumise-cart-param').val();
		calcPriceDiscount(true);
	});

	// $(document).on('change', '.lumise-cart-param[name="quantity"]', function(){
	// 	lumise_price_discount.quantity = $(this).val();
	// 	calcPriceDiscount(true);
	// });

	function calcPriceDiscount(change){
		var decode = JSON.parse(lumise_price_discount.productDiscountCalc);

		var price_new = 0;
		$.each(decode, function(index, value){
			// percentage calc detail cart
			if(lumise_price_discount.quantity >= value.min_quantity && lumise_price_discount.quantity <= value.max_quantity && value.discount_type == 'percentage'){
				// total_price = (lumise_price_discount.price*lumise_price_discount.quantity)*value.discount_value/100/lumise_price_discount.quantity;
				total_price = ((100-parseFloat(value.discount_value))/100)*parseFloat(lumise_price_discount.price);
				price_new = total_price;
				return false;
			}

			// fixed calc detail cart
			if(lumise_price_discount.quantity >= value.min_quantity && lumise_price_discount.quantity <= value.max_quantity && value.discount_type == 'fixed'){
				// price_new = value.discount_value/lumise_price_discount.quantity;
				price_new = parseFloat(value.discount_value);
				return false;
			}

			// fixed minus calc detail cart
			if(lumise_price_discount.quantity >= value.min_quantity && lumise_price_discount.quantity <= value.max_quantity && value.discount_type == 'minus_fixed'){
				// price_new = value.discount_value/lumise_price_discount.quantity;
				price_new = parseFloat(parseFloat(lumise_price_discount.price) - parseFloat(value.discount_value));
				return false;
			}

		});

		if(decode.length == 0){
			return;
		}

		if(price_new == 0){
			lumise.cart.price.base = parseFloat(price_base);
			lumise.cart.display();
			return false;
		}
		
		if(change == false && typeof lumise.data.onload != "undefined"){
			lumise.data.onload.price = price_new;
		}

		if(typeof lumise.ops.product_data != "undefined"){
			lumise.ops.product_data.price = price_new;
		}

		lumise.cart.price.base = price_new;
		if(change == true){
			lumise.cart.display();
		}
	}

	// change product
	lumise.add_action('select-product', function(productDetail){
        lumise.f('Loading..');
		$.ajax({
			url: lumise.data.ajax,
			method: 'POST',
			dataType: "json",
			data: {
				nonce: 'LUMISE-SECURITY:'+lumise.data.nonce,
				ajax: 'frontend',
				action: 'addon',
				component: 'lumise_change_single_product_ed',
				product_id: productDetail.product
			},
			statusCode: {
				403: function(){
					alert('Error 403');
				}
			},
			success: function(result) {
				if(result.status == 0){
					return;
				}
				if(result.status == 1){
					if(result.message.productDiscountCalc != '[]'){
						lumise_price_discount = result.message;
						calcPriceDiscount(true);

						// lumise.fn.clear_url([]);
						// lumise.render.product(product[0]);
					}

				}
				lumise.f(false);
	        }
		});
	});

	lumise.add_action('updated', function() {
		// // lumise.f('Loading..');
		// $.ajax({
		// 	url: lumise.data.ajax,
		// 	method: 'POST',
		// 	dataType: "json",
		// 	data: {
		// 		nonce: 'LUMISE-SECURITY:'+lumise.data.nonce,
		// 		ajax: 'frontend',
		// 		action: 'addon',
		// 		component: 'lumise_change_single_product_ed',
		// 		product_id: lumise.ops.product_data.product
		// 	},
		// 	statusCode: {
		// 		403: function(){
		// 			alert('Error 403');
		// 		}
		// 	},
		// 	success: function(result) {
		// 		if(result.status == 0){
		// 			return;
		// 		}
		// 		if(result.status == 1){
		// 			if(result.message.productDiscountCalc != '[]'){
		// 				lumise_price_discount = result.message;
		// 				calcPriceDiscount(true);

		// 				// lumise.fn.clear_url([]);
		// 				// lumise.render.product(product[0]);
		// 			}

		// 		}
		// 		// lumise.f(false);
	 //        }
		// });
	});

}