<?php
	
	$prefix = 'price_discount_';
	$title = "Price discount rule";

	// Action Form
	if (isset($_POST['action_submit']) && !empty($_POST['action_submit'])) {

		$data_action = isset($_POST['action']) ? $_POST['action'] : '';
		$val = isset($_POST['id_action']) ? $_POST['id_action'] : '';
		$val = explode(',', $val);

		foreach ($val as $value) {

			$dt = $lumise_admin->get_row_id($value, 'price_discount');
			switch ($data_action) {
				case 'active':
					$data = array(
						'active' => 1
					);
					$dt = $lumise_admin->edit_row( $value, $data, 'price_discount' );
					break;
				case 'deactive':
					$data = array(
						'active' => 0
					);
					$dt = $lumise_admin->edit_row( $value, $data, 'price_discount' );
					break;
				case 'delete':
					$arr = array("id","item_id");
					$cate_reference = $lumise_admin->get_rows_custom($arr, 'categories_reference', $orderby = 'id', $order='asc');

					foreach ($cate_reference as $vals) {
						if ($vals['item_id'] == $value) {
							$lumise_admin->delete_row($vals['id'], 'categories_reference');
						}
					}

					$arr = array("id","item_id");
					$tag_reference = $lumise_admin->get_rows_custom($arr, 'tags_reference', $orderby = 'id', $order='asc');

					foreach ($tag_reference as $vals) {
						if ($vals['item_id'] == $value) {
							$lumise_admin->delete_row($vals['id'], 'tags_reference');
						}
					}

					$lumise_admin->delete_row($value, 'price_discount');
					break;
				default:
					break;
			}

		}
	}

	// Pagination
	$per_page = 20;
	if(isset($_SESSION[$prefix.'per_page']))
		$per_page = $_SESSION[$prefix.'per_page'];

	if (isset($_POST['per_page'])) {

		$data = isset($_POST['per_page']) ? $_POST['per_page'] : '';

		if ($data != 'none') {
			$_SESSION[$prefix.'per_page'] = $data;
			$per_page = $_SESSION[$prefix.'per_page'];
		} else {
			$_SESSION[$prefix.'per_page'] = 20;
			$per_page = $_SESSION[$prefix.'per_page'];
		}

	}


	if (isset($_POST['do']) && !empty($_POST['do'])) {
		$lumise->redirect($lumise->cfg->admin_url . "lumise-page=price_discount");
		exit;
	}


	// Get row pagination
    $current_page = isset($_GET['tpage']) ? $_GET['tpage'] : 1;
    
    // query
    $query = array();
    $select = "SELECT id, name, active FROM {$lumise->db->prefix}price_discount";

    $start = ( $current_page - 1 ) *  $per_page;
	array_push($query, " LIMIT ".$start.",".$per_page);

	$datas = $lumise->db->rawQuery($select.implode(' ', $query));

    $total_record = $lumise->db->rawQuery("SELECT count(*) as total FROM {$lumise->db->prefix}price_discount");

    $config = array(
    	'current_page'  => $current_page,
		'total_record'  => $total_record[0]['total'],
		'total_page'    => ceil($total_record[0]['total']/$per_page),
 	    'limit'         => $per_page,
	    'link_full'     => $lumise->cfg->admin_url.'lumise-page=price_discount&tpage={page}',
	    'link_first'    => $lumise->cfg->admin_url.'lumise-page=price_discount',
	);

	$lumise_pagination->init($config);
	
?>

<div class="lumise_wrapper">

	<div class="lumise_content">

		<div class="lumise_header">
			<h2><?php echo $lumise->lang('price discount'); ?></h2>
			<a href="<?php echo $lumise->cfg->admin_url;?>lumise-page=add_price_discount" class="add_new">
				<i class="fa fa-plus"></i>
				<?php echo $lumise->lang('Add New Price discount rule'); ?>
			</a>
		</div>

		<div class="lumise_option">
			<div class="left">
				<form action="<?php echo $lumise->cfg->admin_url;?>lumise-page=price_discount" method="post">
					<select name="action" class="art_per_page">
						<option value="none"><?php echo $lumise->lang('Bulk Actions'); ?></option>
						<option value="active"><?php echo $lumise->lang('Active'); ?></option>
						<option value="deactive"><?php echo $lumise->lang('Deactive'); ?></option>
						<option value="delete"><?php echo $lumise->lang('Delete'); ?></option>
					</select>
					<input type="hidden" name="id_action" class="id_action">
					<input type="hidden" name="do" value="action" />
					<input type="submit" class="lumise_submit" name="action_submit" value="<?php echo $lumise->lang('Apply'); ?>" />
					<?php $lumise->securityFrom();?>
				</form>
				<form action="<?php echo $lumise->cfg->admin_url;?>lumise-page=price_discount" method="post" class="less">
					<select name="per_page" data-action="submit" class="art_per_page">
						<option value="none">-- <?php echo $lumise->lang('Per page'); ?> --</option>
						<?php
							$per_pages = array('20', '50', '129', '200', '300');

							foreach($per_pages as $val) {

							    if($val == $per_page) {
							        echo '<option selected="selected">'.$val.'</option>';
							    } else {
							        echo '<option>'.$val.'</option>';
							    }

							}
						?>
					</select>
					<input type="hidden" name="perpage" value="<?php echo $lumise->lang('Per Page'); ?>" />
					<input type="hidden" name="do" value="limit" />
					<?php $lumise->securityFrom();?>
				</form>
			</div>
			<div class="right">
			</div>
		</div>

		<?php if (count($datas) > 0) { ?>

		<div class="lumise_wrap_table">
			<table class="lumise_table lumise_price_discounts">
				<thead>
					<tr>
						<th class="lumise_check">
							<div class="lumise_checkbox">
								<input type="checkbox" id="check_all">
								<label for="check_all"><em class="check"></em></label>
							</div>
						</th>
						<th width="20%"><?php echo $lumise->lang('Name'); ?></th>
						<th><?php echo $lumise->lang('Active'); ?></th>
					</tr>
				</thead>
				<tbody>
					<?php

						foreach ($datas as $data) { ?>

							<tr>
								<td class="lumise_check">
									<div class="lumise_checkbox">
										<input type="checkbox" name="checked[]" class="action_check" value="<?php if(isset($data['id'])) echo $data['id']; ?>" class="action" id="<?php if(isset($data['id'])) echo $data['id']; ?>">
										<label for="<?php if(isset($data['id'])) echo $data['id']; ?>"><em class="check"></em></label>
									</div>
								</td>
								<td><a href="<?php echo $lumise->cfg->admin_url;?>lumise-page=add_price_discount&id=<?php if(isset($data['id'])) echo $data['id'] ?>" class="name"><?php if(isset($data['name'])) echo $data['name']; ?></a></td>
								<td>
									<a href="#" class="lumise_action" data-type="price_discount" data-action="switch_active" data-status="<?php echo (isset($data['active']) ? $data['active'] : '0'); ?>" data-id="<?php if(isset($data['id'])) echo $data['id'] ?>">
										<?php
											if (isset($data['active'])) {
												if ($data['active'] == 1) {
													echo '<em class="pub">'.$lumise->lang('Active').'</em>';
												} else {
													echo '<em class="un pub">'.$lumise->lang('Deactive').'</em>';
												}
											}
										?>
									</a>
								</td>
							</tr>

						<?php } ?>
				</tbody>
			</table>
		</div>
		<div class="lumise_pagination"><?php echo $lumise_pagination->pagination_html(); ?></div>

		<?php } else {echo '<p class="no-data">'.$lumise->lang('Apologies, but no results were found.').'</p>';}?>

	</div>

</div>

<script type="text/javascript">

</script>
