<?php
/*
Name: Images+
Description: Upload & manage images from backend, Setup APIs for free online images
Version: 1.0
Compatible: 1.9
*/

class lumise_addon_images extends lumise_addons {
	
	function __construct() {
		
		global $lumise;
		
		/*
		*	Access core js via your JS function name
		*/
		
		$this->access_corejs('lumise_addon_advancedImages');
		
		$lumise->add_filter('editor_menus', array(&$this, 'editor_menus'));
		
		/*
		*	Insert your code like css, js into header and footer
		*/
		
		$lumise->add_action('editor-header', array(&$this, 'editor_header'));
		$lumise->add_action('editor-footer', array(&$this, 'editor_footer'));
		
		/*
		*	Add new left menu in backend	
		*/
		
		$lumise->add_filter('admin_menus', array(&$this, 'admin_menus'));
		
		/*
		*	Display Lumise page in backend
		*/
		
		$lumise->add_filter('admin_page', array(&$this, 'admin_page'));
		
		/*
		*	Register new folder uploads
		*/
		
		$lumise->add_filter('upload_folders', array(&$this, 'upload_folders'));
		
		
		$lumise->cfg->ex_settings(array(
			//'internal_resources' => 'yes',
			'facebook_app' => '',
			'instagram_api' => '',
			'instagram_api_secret' => '',
			'ex_activate' => '',
			'pixabay_key' => '',
			'unsplash_key' => '',
		));
		/*
		*	Action ajax
		*/
		
		$lumise->add_action('addon-ajax', array(&$this, 'ajax_action'));
		
		/*
		*	Add role for manage component images (Wordpress Platform)
		*/
		
		if ($lumise->connector->platform == 'woocommerce') {
			$role = get_role('administrator');
			$role->add_cap('lumise_read_images');
			$role->add_cap('lumise_edit_images');

			// REST API for addon IMAGES
			add_action('rest_api_init', function () {
			  register_rest_route( 'lumise_addon/v1', '/auth_instagram',array(
		                'methods'  => 'GET',
		                'callback' => array(&$this, 'rest_auth_instagram'),
		                'permission_callback' => '__return_true',
			      ));
			});
		}
					
		// REST API for addon IMAGES
		if ($lumise->connector->platform == 'php') {
			$lumise->add_action('api_request', array(&$this, 'rest_auth_instagram'));
		}
	}
	
	public function rest_auth_instagram(){
		global $lumise;
		if(!isset($_GET['state'])) return;
		
		$state = json_decode(base64_decode($_GET['state']),true);
		
		if($lumise->connector->platform == 'php'){
		    if(!empty($state['api_action']) && $state['api_action'] != 'auth_instagram') return;

			$redirect = $lumise->cfg->url .'api.php';
		}else{
			$redirect = get_rest_url( null, 'lumise_addon/v1/auth_instagram' );
		}	
	
		// check parameter
		if( !isset($_GET['code']) || !isset($lumise->cfg->settings['instagram_api']) || !isset($lumise->cfg->settings['instagram_api_secret'])){
			echo json_encode(array('status' => 0, 'message' => 'missing data'));
			die();
		}

		$data = array(
			'client_id' => $lumise->cfg->settings['instagram_api'],
			'client_secret' => $lumise->cfg->settings['instagram_api_secret'],
			'grant_type' => 'authorization_code',
			'redirect_uri' => $redirect,
			'code' => $_GET['code'],
		);
		
		$rs = $this->curl_data('https://api.instagram.com/oauth/access_token', $data, 'POST');

		if(isset($rs->access_token) && !empty($state['referer'])){
	        $url = $state['referer'];
		        
		    $url .= (parse_url($url, PHP_URL_QUERY) ? '&' : '?') . 'instagram_callback=true#access_token='.$rs->access_token; 
		    
		    header("Location: $url");
		    exit();
		}

		die();
	}

	private function curl_data($url, $params, $method = "GET" ){
		$paramString = null;

	    if (isset($params) && is_array($params)) {
	        $paramString = '?' . http_build_query($params);
	    }
	    $url = $url . (('GET' === $method) ? $paramString : null);

		$ch = curl_init();
	    curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept: application/json'));
	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

		if ($method === 'POST') {
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
		}
	    curl_setopt($ch, CURLOPT_TIMEOUT, 60);

	    $jsonData = curl_exec($ch);

	    if (!$jsonData) {
	    	throw new Exception('There here was an error');
	    }
		curl_close($ch);

		return json_decode($jsonData);
	}

	public function editor_menus($args) {
		
		global $lumise;
		
		$args['uploads']['content'] = (
			($lumise->connector->is_admin() || $lumise->cfg->settings['disable_resources'] != 1) 
			? '<header class="images-from-socials lumise_form_group">
				<button class="active" data-nav="xinternal">
					<i class="lumise-icon-layers"></i>
					<br>
					'.$lumise->lang('Library').'
				</button>
				<button data-nav="internal">
					<i class="lumise-icon-cloud-upload"></i>
					<br>
					'.$lumise->lang('Upload').'
				</button>
				<button data-nav="external">
					<i class="lumise-icon-globe"></i>
					<br>
					'.$lumise->lang('Free').'
				</button>
				<button data-nav="xexternal">
					<i class="lumise-icon-picture"></i>
					<br>
					'.$lumise->lang('Social').'
				</button>
			</header>' : ''
			).
			'<div data-tab="xinternal" class="active">'.
				$this->render_xitems(array(
					"component" => "images",
					"search" => true,
					"category" => true,
					"preview" => true,
					"price" => true
				)).'
			</div>
			<div data-tab="internal">
				<div id="lumise-upload-form">
					<i class="lumise-icon-cloud-upload"></i>
					<span>'.$lumise->lang('Click or drop images here').'</span>
					<input type="file" multiple="true" />
				</div>
				<div id="lumise-upload-list">
					<ul class="lumise-list-items"></ul>
				</div>
			</div>
			<div data-tab="external" id="lumise-external-images"></div>
			<div data-tab="xexternal" id="lumise-xexternal-images"></div>';
			
		return $args;
		
	}
	
	public function admin_menus($args) {
		
		global $lumise;
		
		$position = 4;
		
		$new_menu = array(
			"images" => array(
				'title' => $lumise->lang('Images'),
				'icon'  => '<i class="fa fa-image"></i>',
				'child' => array(
					'images'   => array(
						'type'   => '',
						'title'  => $lumise->lang('All Images'),
						'link'   => $lumise->cfg->admin_url.'lumise-page=images',
						'hidden' => false,
					),
					'image' => array(
						'type'   => '',
						'title'  => $lumise->lang('Add New Image'),
						'link'   => $lumise->cfg->admin_url.'lumise-page=image',
						'hidden' => false,
					),
					'categories' => array(
						'type'   => 'images',
						'title'  => $lumise->lang('Images Categories'),
						'link'   => $lumise->cfg->admin_url.'lumise-page=categories&type=images',
						'hidden' => false,
					),
					'category' => array(
						'type'   => 'images',
						'title'  => $lumise->lang('Add New Category'),
						'link'   => $lumise->cfg->admin_url.'lumise-page=category&type=images',
						'hidden' => true,
					),
					'tags' => array(
						'type'   => 'images',
						'title'  => $lumise->lang('Tags'),
						'link'   => $lumise->cfg->admin_url.'lumise-page=tags&type=images',
						'hidden' => false,
					),
					'tag' => array(
						'type'   => 'images',
						'title'  => $lumise->lang('Add New Tag'),
						'link'   => $lumise->cfg->admin_url.'lumise-page=tag&type=images',
						'hidden' => true,
					),
				),
				'capability' => 'lumise_read_images'
			)
		);
		
		return array_slice($args, 0, $position, true) + 
			   $new_menu + 
			   array_slice($args, $position, count($args) - 1, true);
			   
	}
	
	public function admin_page($path, $page) {
		
		if ($page == 'image')
			return dirname(__FILE__).DS.'image.php';
		else if ($page == 'images')
			return dirname(__FILE__).DS.'images.php';
		else return $path;
		
	}
	
	public function upload_folders($args) {
		array_push($args, 'images');
		return $args;
	}
	
	public function settings() {
		
		global $lumise;
		if ($lumise->connector->platform == 'woocommerce')
			$url = site_url() .'/wp-json/lumise_addon/v1/auth_instagram';
		elseif ($lumise->connector->platform == 'php')
			$url = $lumise->cfg->url .'api.php';

		return array(
			/*array(
				'type' => 'toggle',
				'name' => 'internal_resources',
				'label' => $lumise->lang('Lumise service'),
				'desc' => $lumise->lang('Use Lumise server to load external images. If you have the APIs, switch off this and enter them in the fields below'),
				'default' => 'yes',
				'value' => 'yes'
			),*/
			array(
				'type' => 'checkboxes',
				'name' => 'ex_activate',
				'label' => $lumise->lang('Activate'),
				'options' => array(
					'fb' => 'Facebook',
					'in' => 'Instagram',
					'pi' => 'Pixabay',
					'un' => 'Unsplash',
					'bu' => 'Burst'
				)
			),	
			array(
				'type' => 'input',
				'name' => 'facebook_app',
				'label' => $lumise->lang('Facebook App ID'),
				'desc' => '<a href="https://magefan.com/blog/create-facebook-application" target=_blank>Create a Facebook APP</a> <code>(Requiring HTTPS)</code>'
			),
			array(
				'type' => 'input',
				'name' => 'instagram_api',
				'label' => $lumise->lang('Instagram App ID'),
				'desc' => '<a href="https://developers.facebook.com/docs/instagram-basic-display-api/getting-started" target=_blank>Create a Instagram APP</a> <code>(Requiring HTTPS)</code>'
			),
			array(
				'type' => 'input',
				'name' => 'instagram_api_secret',
				'label' => $lumise->lang('Instagram App Secret'),
				'desc' => 'OAuth Redirect URIs : <code>'. $url .'</code>'
			),
			array(
				'type' => 'input',
				'name' => 'pixabay_key',
				'label' => $lumise->lang('Pixabay API Key'),
				'desc' => '<a href="https://pixabay.com/api/docs/#api_search_images" target=_blank>Pixabay API key</a>'
			),
			array(
				'type' => 'input',
				'name' => 'unsplash_key',
				'label' => $lumise->lang('Unsplash API Key'),
				'desc' => '<a href="https://www.odoo.com/documentation/15.0/applications/websites/website/optimize/unsplash.html" target=_blank>Create a Unsplash APP </a>'
			),
		);	
	}
	
	public function editor_header() {
		
		if (!$this->is_backend()) 
			echo '		<link rel="stylesheet" href="'.$this->get_url('assets/css/images.css?ver=1').'" type="text/css" media="all" />';
		
	}
	
	public function editor_footer() {
		
		global $lumise;
		

		if (!$this->is_backend()) {
			if ($lumise->connector->platform == 'woocommerce')
				$in_ru = site_url() .'/wp-json/lumise_addon/v1/auth_instagram';
			elseif ($lumise->connector->platform == 'php')
				$in_ru = $lumise->cfg->url .'api.php';

			/*"external": "'.(isset($lumise->cfg->settings['internal_resources']) ? $lumise->cfg->settings['internal_resources'] : '').'",*/
			echo '<script type="text/javascript">var lumise_images_addon_cfg = {
				"api": {
					"actv": "'.(isset($lumise->cfg->settings['ex_activate']) ? $lumise->cfg->settings['ex_activate'] : '').'",
					"fb": "'.(isset($lumise->cfg->settings['facebook_app']) ? $lumise->cfg->settings['facebook_app'] : '').'",
					"in": "'.(isset($lumise->cfg->settings['instagram_api']) ? $lumise->cfg->settings['instagram_api'] : '').'",
					"pi": "'.(isset($lumise->cfg->settings['pixabay_key']) ? $lumise->cfg->settings['pixabay_key'] : '').'",
					"un": "'.(isset($lumise->cfg->settings['unsplash_key']) ? $lumise->cfg->settings['unsplash_key'] : '').'",
					"in_ru": "'.$in_ru.'",
				}
			}</script>';
			echo '<script type="text/javascript" src="'.$this->get_url('assets/js/images.js?ver=1').'"></script>';
		}
	}
	
	public function ajax_action() {
		
		global $lumise;
		
		if (isset($_POST['component']) && $_POST['component'] == 'images') {
			$lumise->lib->x_items('images');
		}
	}
	
	/*
		Actions on active or deactive this addon
	*/
	
	static function active() {
		
		global $lumise;
		
		$lumise->db->rawQuery("CREATE TABLE  IF NOT EXISTS `".$lumise->db->prefix."images` (
			`id` int(11) NOT NULL,
			`name` varchar(255) CHARACTER SET utf8 NOT NULL,
			`upload` text CHARACTER SET utf8,
			`thumbnail_url` text CHARACTER SET utf8,
			`price` float DEFAULT '0',
			`featured` int(1) DEFAULT NULL,
			`active` int(1) DEFAULT NULL,
			`author` varchar(255) DEFAULT NULL,
			`order` int(1) DEFAULT NULL,
			`tags` varchar(255) CHARACTER SET utf8 NOT NULL,
			`use_count` int(11) DEFAULT NULL,
			`created` datetime DEFAULT NULL,
			`updated` datetime DEFAULT NULL
			) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;");
		
		$lumise->db->rawQuery("ALTER TABLE `".$lumise->db->prefix."images` ADD PRIMARY KEY (`id`);");
		$lumise->db->rawQuery("ALTER TABLE `".$lumise->db->prefix."images` CHANGE `id` `id` INT(11) NOT NULL AUTO_INCREMENT;");	
		$lumise->db->rawQuery("ALTER TABLE `".$lumise->db->prefix."images` MODIFY `author` VARCHAR(255) NOT NULL DEFAULT ''");
		$lumise->db->rawQuery("UPDATE `".$lumise->db->prefix."images` SET `author` = '{$lumise->vendor_id}'");
	}


}