function lumise_addon_background(lumise) {
	
	window.lm = lumise;
	
	var add_bg = function(url, price, mode, cb) {
		
		var stage = lumise.stage(),
			objects = stage.canvas.getObjects();
		
		lumise.f('Loading..');
		fabric.util.loadImage(url, function(img) {
			
			// Process mode here
			
			var ops = {
				left: stage.canvas.width/2,
				top: (stage.canvas.height-40)/2,
				width: stage.product.width,
				height: stage.product.height,
				selectable: false,
				evented: false,
				url: url,
				price: price
			};
			
			stage.backgrounds = new fabric.Image(img);
			stage.backgrounds.set(ops);
			
			objects.splice(1, 0, stage.backgrounds);
			
			lumise.f(false);
			bg_image_mode(mode);
			
			stage.canvas.renderAll();
			
			if (typeof cb == 'function')
				cb();
					
		});
		
		if (mode != $('#lumise-addon-background-options').val())
			$('#lumise-addon-background-options option[value="'+mode+'"]').prop({selected: true});
		
		lumise.tools.discard();		
			
	},
	
	bg_image_mode = function(mode) {
		
		var stage = lumise.stage();
		
		if (
			stage.backgrounds === undefined ||
			stage.backgrounds.get('url') === undefined ||
			stage.backgrounds.get('mode') == mode
		) return;
		
		stage.backgrounds.set({'mode': mode});
		
		var cv = document.createElement('canvas'),
			ctx = cv.getContext('2d'),
			img = new Image();
		
		cv.width = stage.product.width;
		cv.height = stage.product.height;
		
		lumise.f('Loading..');
		img.onload = function() {
		
			if (mode == 'fill') {
					
				var w = stage.product.width,
					h = stage.product.width*(this.height/this.width),
					l = 0,
					t = -(h-stage.product.height)/2;
					
				if (h < stage.product.height) {
					w = stage.product.height*(this.width/this.height);
					h = stage.product.height;
					t = 0;
					l =  -(w-stage.product.width)/2;
				}
				
				ctx.drawImage(this, l, t, w, h);
				
			} else if (mode == 'fit') {
				
				var w = stage.product.width,
					h = stage.product.width*(this.height/this.width),
					l = 0,
					t = (stage.product.height-h)/2;
					
				if (h > stage.product.height) {
					w = stage.product.height*(this.width/this.height);
					h = stage.product.height;
					t = 0;
					l =  (stage.product.width-w)/2;
				}
				
				ctx.drawImage(this, l, t, w, h);
				
			} else if (mode == 'tile') {
				
				var rows = Math.ceil(stage.product.height/this.height),
					cols = Math.ceil(stage.product.width/this.width);
				
				for (var i=0; i<rows; i++) {
					for (var j=0; j<cols; j++) {
						ctx.drawImage(this, j*this.width, i*this.height);
					}
				}
				
				ctx.drawImage(this, l, t, w, h);
				
			} else if (mode == 'stretch') {
				ctx.drawImage(this, 0, 0, cv.width, cv.height);
			}

			stage.backgrounds.setElement(cv);
			stage.backgrounds.set({
				width: stage.product.width,
				height: stage.product.height
			});
			
			stage.canvas.renderAll();
			lumise.stack.save();
			
			lumise.f(false);
			
		};
		
		img.src = stage.backgrounds.get('url');
		
	};
	
	lumise.design.nav.load.backgrounds = function(e) {
		
		lumise.xitems.load('backgrounds', {
			
			preview: 'image',	// image|template
			
			// response : function(res) {
			//		/*	do filter response	*/
			//		return res;
			//},
			
			load: function(res) {
				$('#lumise-backgrounds-list ul li').css({display: ''});
				return res;
			},
			response: function(res) {
				if ($('#lumise-backgrounds-list ul li.do-empty').length === 0) {
					$('#lumise-backgrounds-list ul').prepend('<li title="Empty background" style="" class="lumise-xitem do-empty" data-ops="[{&quot;empty&quot;: true}]"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" viewBox="-300 -200 800 800" xml:space="preserve"><path fill="#ff11009e" d="M131.804,106.491l75.936-75.936c6.99-6.99,6.99-18.323,0-25.312   c-6.99-6.99-18.322-6.99-25.312,0l-75.937,75.937L30.554,5.242c-6.99-6.99-18.322-6.99-25.312,0c-6.989,6.99-6.989,18.323,0,25.312   l75.937,75.936L5.242,182.427c-6.989,6.99-6.989,18.323,0,25.312c6.99,6.99,18.322,6.99,25.312,0l75.937-75.937l75.937,75.937   c6.989,6.99,18.322,6.99,25.312,0c6.99-6.99,6.99-18.322,0-25.312L131.804,106.491z"></path></svg></li>');
				}
				return res;	
			},
			click: function(data) {
				
				var stage = lumise.stage(),
					objects = stage.canvas.getObjects();
				
				if (data.empty === true) {
					
					lumise.stack.save();
					stage.canvas.remove(stage.backgrounds);
					delete stage.backgrounds;
					lumise.stack.save();
					
					return;
					
				};
				
				var mode =  $('#lumise-addon-background-options').val();
				
				if (stage.backgrounds === undefined) {
					add_bg(data.url, data.price, mode, lumise.stack.save);
				} else {
					stage.backgrounds.set({url: data.url, price: data.price, mode: null});
					bg_image_mode(mode);
				}
				
			}
		});
				
	};
	
	lumise.add_filter('export', function(data, stage) {
		
		if (stage.backgrounds !== undefined && stage.backgrounds.url !== undefined) {
			data.background_url = stage.backgrounds.url;
			data.background_price = stage.backgrounds.price;
			data.background_mode = stage.backgrounds.mode
		}

		return data;
		
	});
		
	lumise.add_filter('import', function(data) {
		
		var stage = lumise.stage();
		
		if (
			data !== undefined 
			&& (
				stage.backgrounds === undefined || (stage.template_id !== undefined && stage.template_id != '')
			)
			&& data.background_url !== undefined
		) {
			if(data.background_url && stage.backgrounds){
				lumise.stack.save();
				stage.canvas.remove(stage.backgrounds);
				delete stage.backgrounds;
				lumise.stack.save();
			}
			add_bg(data.background_url, data.background_price, data.background_mode);
		}
			
		return data;
		
	});
	
	lumise.add_action('product', function(data) {
		
		lumise.post({
			action: 'addon',
			component: 'get_backgrounds',
			id: lumise.data.product
		}, function(res) {
			
			var wrp = $('#lumise-workspace #backgrounds-theme');
			
			if (res !== '') {
				
				wrp.html('');
				
				res = JSON.parse(decodeURIComponent(res));
				res.map(function(bg) {
					wrp.append('<span title="Set this background" data-upload="'+encodeURI(bg.upload)+'" data-price="'+encodeURI(bg.price)+'"><img src="'+bg.thumbn+'" height="34" /></span>');
				});
				
				wrp.append('<span title="Empty background" data-empty="true"><svg height="34" width="34" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" viewBox="-150 -150 500 500" xml:space="preserve"><path fill="#ff11009e" d="M131.804,106.491l75.936-75.936c6.99-6.99,6.99-18.323,0-25.312   c-6.99-6.99-18.322-6.99-25.312,0l-75.937,75.937L30.554,5.242c-6.99-6.99-18.322-6.99-25.312,0c-6.989,6.99-6.989,18.323,0,25.312   l75.937,75.936L5.242,182.427c-6.989,6.99-6.989,18.323,0,25.312c6.99,6.99,18.322,6.99,25.312,0l75.937-75.937l75.937,75.937   c6.989,6.99,18.322,6.99,25.312,0c6.99-6.99,6.99-18.322,0-25.312L131.804,106.491z"></path></svg></span>');
				
				wrp.find('span').on('click', function(e) {
					
					var stage = lumise.stage();
					
					if (this.getAttribute('data-empty') == 'true') {
						lumise.stack.save();
						stage.canvas.remove(stage.backgrounds);
						delete stage.backgrounds;
						lumise.stack.save();
						return;
					}
					
					var mode =  $('#lumise-addon-background-options').val(),
						url = lumise.data.upload_url+this.getAttribute('data-upload'),
						price = this.getAttribute('data-price');
						
					if (stage.backgrounds === undefined) {
						add_bg(url, price, mode, lumise.stack.save);
					} else {
						stage.backgrounds.set({url: url, price: price, mode: null});
						bg_image_mode(mode);
					}
					
				});
				
			} else {
				wrp.hide();
			}
		});

	});


	lumise.add_action('template', function(tmp, res) {
		var cur = lumise.current_stage;

		if(typeof(tmp.id) != "undefined" && typeof(res.stages) != "undefined" && typeof(res.stages.lumise) != "undefined" && lumise.data.stages[cur] && res.stages['lumise'].data){
			lumise.data.stages[cur].template_id = tmp.id;
		}
	});
	
	$('#lumise-addon-background-options').on('change', function() {
		bg_image_mode(this.value);
	});
	
	$('#lumise-workspace').append('<div id="backgrounds-theme"></div>');
	
}